//
//  MPLocalizedTextField.h
//  MPServices
//
//  Created by Oleksii Dykan on 28/08/2014.
//  Copyright (c) 2014 MacPhun. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MPLocalizedTextField : NSTextField

@property (nonatomic, assign) IBInspectable BOOL localizeStringValue; // YES - default
@property (nonatomic, assign) IBInspectable BOOL localizePlaceholder; // YES - default
@property(nonatomic, assign) IBInspectable CGFloat lineSpacing;
@property(nonatomic, assign) IBInspectable CGFloat textLineMaxHeight;

- (void)commonInit;
- (void)setPlaceholderString:(NSString *)placeholderString;
- (NSString*)placeholderString;
- (void)setPlaceholderAttributedString:(NSAttributedString*)attributedString;
- (NSAttributedString*)placeholderAttributedString;
- (void)setPlaceholderColor:(NSColor*)placeholderColor;
- (void)updateAttributes;

@end
